module Network.XMPP.Presence (
    Presence(..),
    Status(..),
    StatusType(..),
    doPresence
) where

import Network.XMPP


data Presence = Available Status
              | Unavailable Status
              | Subscribe
              | Subscribed
              | Unsubscribe
              | Unsubscribed
              | Probe
              | Error

data Status = Status StatusType [String]

data StatusType = StatusOnline
                | StatusAway
                | StatusChat
                | StatusDND
                | StatusXA
                | StatusOffline


-- | Parse presence stanza.
doPresence :: XMLElem -> Presence
doPresence stanza =
    let stanzaType = getAttr "type" stanza
        statuses = map cdata $ xmlPath' ["status"] [stanza]
        statusType = case cdata' $ xmlPath ["show"] stanza of
                       Just "away" -> StatusAway
                       Just "chat" -> StatusChat
                       Just "dnd" -> StatusDND
                       Just "xa" -> StatusXA
                       _ -> StatusOnline
    in case stanzaType of
         Nothing -> Available (Status statusType statuses)
         Just "unavailable" -> Unavailable (Status StatusOffline statuses)
         Just "subscribe" -> Subscribe
         Just "subscribed" -> Subscribed
         Just "unsubscribe" -> Unsubscribe
         Just "unsubscribed" -> Unsubscribed
         Just "probe" -> Probe
         Just "error" -> Error
         _ -> Error

---
cdata' = getCdata . maybe (XML "" [] []) id
