module Network.XMPP.Roster (
    RosterItem(..),
    Subscription(..),
    getRoster
) where

import Network.XMPP


data RosterItem = RosterItem
    { itemName :: String
    , itemJid :: String
    , itemSubscription :: Subscription
    , itemGroups :: [String]
    } deriving Show

-- "There are nine possible subscription states"
-- It's horrible.
data Subscription = SBoth | SFrom | STo | SNone | SUnknown
                    deriving Show


getRoster :: XMPP [RosterItem]
getRoster = do
    stanza <- sendIqWait "" "get" [XML "query" [("xmlns", "jabber:iq:roster")] []]
    let items = xmlPath' ["query", "item"] [stanza]
    return $ map getItem items
  where
    getItem item =
      let getAttr' attr = maybe "" id $ getAttr attr item

          name = getAttr' "name"
          jid = getAttr' "jid"
          groups = map cdata $ xmlPath' ["group"] [item]
          subs = case getAttr' "subscription" of
                   "to" -> STo
                   "from" -> SFrom
                   "both" -> SBoth
                   "none" -> SNone
                   _ -> SUnknown
      in RosterItem name jid subs groups
